# 1Password Tools

> This is a collection of 1Password related CLI tools and helpers.
> Since version 1.0.0, this tool is made for op CLI version 2.0

```
Usage: op-tools [OPTIONS] COMMAND [ARGS]...

Options:
  -v, --verbosity LVL  Either CRITICAL, ERROR, WARNING, INFO or DEBUG
  --help               Show this message and exit.

Commands:
  new-database-account  Create a new Database item in 1Password with the...
  new-server-account    Create a new Server item in 1Password with the
                        given...
  new-ssh-key           Generates a new SSH key and store it in 1Password.
  new-website-account   Create a new Login item in 1Password with the given...
  ssh-add               Loads a SSH key stored in 1Password by searching...

```

## new-database-account

```
Usage: op-tools new-database-account [OPTIONS]

  Create a new Database item in 1Password with the given credentials.

Options:
  --return-field TEXT        Field value to return
  --account TEXT             Account to use (shorthand)
  --vault TEXT               Vault uuid where to store the information
  --title TEXT               Name of the 1Password item
  --notes TEXT               Note
  --password-length INTEGER  Autogenerated password length, default 25
  --password TEXT            Password to use, default autogenerated
  --database TEXT            Database name  [required]
  --hostname TEXT            Host where the account is created  [required]
  --port TEXT                Database port
  --username TEXT            Account username  [required]

```

## new-server-account

```
Usage: op-tools new-server-account [OPTIONS]

  Create a new Server item in 1Password with the given credentials.

Options:
  --return-field TEXT        Field value to return
  --account TEXT             Account to use (shorthand)
  --vault TEXT               Vault uuid where to store the information
  --title TEXT               Name of the 1Password item
  --notes TEXT               Note
  --password-length INTEGER  Autogenerated password length, default 25
  --password TEXT            Password to use, default autogenerated
  --hostname TEXT            Host where the account is created  [required]
  --username TEXT            Account username  [required]
  --help                     Show this message and exit.
```

## new-ssh-key

```
Usage: op-tools new-ssh-key [OPTIONS]

  Generates a new SSH key and store it in 1Password. Additional information
  are stored also to generate SSH config file when imported.

Options:
  --return-field TEXT          Field value to return
  --account TEXT               Account to use (shorthand)
  --vault TEXT                 Vault uuid where to store the information
  --title TEXT                 Name of the 1Password item
  --notes TEXT                 Note
  --from-user TEXT             User who is responsible from initiating the
                               connection, default current user.
  --from-host TEXT             Host from where the SSH connection starts,
                               default current hostname.
  --to-user TEXT               Remote user, prompted if empty.  [required]
  --to-host TEXT               Remote server hostname, prompted if empty.
                               [required]
  --to-host-abbreviated TEXT   Alias of the remote server hostname used to
                               initialize connection.
  --no-passphrase TEXT         Create ssh key without passphrase.
  --passphrase TEXT            Use this passphrase instead of an autogenerated
                               one.
  --passphrase-length INTEGER  Length of the autogenerated passphrase.
  --port INTEGER               Remote port
  --help                       Show this message and exit.
```

## new-website-account 

```
Usage: op-tools new-website-account [OPTIONS]

  Create a new Login item in 1Password with the given credentials.

Options:
  --return-field TEXT        Field value to return
  --account TEXT             Account to use (shorthand)
  --vault TEXT               Vault uuid where to store the information
  --title TEXT               Name of the 1Password item
  --notes TEXT               Note
  --password-length INTEGER  Autogenerated password length, default 25
  --password TEXT            Password to use, default autogenerated
  --url TEXT                 URL of the website where the account is created
                             [required]
  --tld_variations TEXT      Create multiple URLs variations or url parameter
                             with the given tld. Provided tld are comma separated.
                             ex: tld_variations=docker,test.fr                             
  --username TEXT            Account username  [required]
  --help                     Show this message and exit.
```

## ssh-add

```
Usage: op-tools ssh-add [OPTIONS] [SEARCH]

  Loads a SSH key stored in 1Password by searching [SEARCH] in uuid or in
  item title, and creates a ssh configuration file of the following format:

  Match originalhost [<Alias>][<Hostname> user <Remote user>]
    IdentitiesOnly yes
    IdentityFile <path to key file>
    Hostname <Hostname>
    User <Remote user>
    Port <Port>

Options:
  -D                    cleanup ssh agent and remove all 1Password managed
                        keys and configuration
  --no-ssh-config TEXT  Do not create ssh config file
  --help                Show this message and exit.

```

